#include <amxmodx>
#include <cstrike>

#define PLUGIN "Admin Free Look"
#define VERSION "1.9"
#define AUTHOR "Jim"

#define ADMIN_ACCESS ADMIN_BAN	//flag "d"
#define TEAMS_KEYS MENU_KEY_1|MENU_KEY_2|MENU_KEY_5|MENU_KEY_0
#define SPECT_KEYS MENU_KEY_1|MENU_KEY_2|MENU_KEY_5|MENU_KEY_6|MENU_KEY_0
#define CLASS_KEYS MENU_KEY_1|MENU_KEY_2|MENU_KEY_3|MENU_KEY_4|MENU_KEY_5

new g_msgTeamInfo
new CsTeams:g_team[33]
new bool:g_corpse[33]
new bool:g_canfreelook[33]
new const team_name[_:CsTeams][] = {"UNASSIGNED", "TERRORIST", "CT", "SPECTATOR"}

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	register_event("HLTV", "freelook_over", "a", "1=0", "2=0")	//VEN
	register_logevent("freelook_over", 2, "1=Round_End")
	register_event("ClCorpse", "hook_corpse", "a", "12>0")
	register_event("TeamInfo", "join_spec", "a", "1>0", "2=SPECTATOR")
	register_event("TextMsg", "join_team", "a", "1=1", "2=#Game_join_terrorist", "2=#Game_join_ct")
	
	register_clcmd("jointeam", "choose_a_team")
	register_clcmd("joinclass", "choose_a_model")
	register_menucmd(register_menuid("IG_Team_Select", 1), TEAMS_KEYS, "ig_team_menu")
	register_menucmd(register_menuid("IG_Team_Select_Spect",1), SPECT_KEYS, "ig_spec_menu")
	register_menucmd(register_menuid("Terrorist_Select", 1), CLASS_KEYS, "join_class_menu")
	register_menucmd(register_menuid("CT_Select", 1), CLASS_KEYS, "join_class_menu")
	
	g_msgTeamInfo = get_user_msgid("TeamInfo")
}

public client_connect(id)
{
	g_team[id] = CS_TEAM_SPECTATOR
	g_corpse[id] = false
	g_canfreelook[id] = true
}

public client_disconnect(id)
{
	g_corpse[id] = false
	g_canfreelook[id] = true
}

public join_spec()
{
	g_team[read_data(1)] = CS_TEAM_SPECTATOR
}

public join_team()
{
	new name[32]
	read_data(3, name, 31)
	new id = get_user_index(name)
	if(is_user_connected(id))
		g_team[id] = cs_get_user_team(id)
}

public choose_a_team(id)
{
	new argv[2]
	read_argv(1, argv, 1)
	switch(argv[0])
	{
		case '1', '2', '5': g_canfreelook[id] = false
		case '6': stay_spec(id)
	}
}

public ig_team_menu(id, key)
{
	if(key == 0 || key == 1 || key == 4)
		g_canfreelook[id] = false
}

public ig_spec_menu(id, key)
{
	if(key == 5)
		stay_spec(id)
}

public choose_a_model(id)
{
	g_canfreelook[id] = true
	if(g_corpse[id])
		set_task(1.0, "free_look", id)
}

public join_class_menu(id, key)
{
	choose_a_model(id)
}

public hook_corpse()
{
	new id = read_data(12)
	if(is_user_connected(id) && !is_user_bot(id) && get_user_flags(id) & ADMIN_ACCESS)
	{
		g_team[id] = cs_get_user_team(id)
		g_corpse[id] = true
		free_look(id)
	}
}

public free_look(id)
{
	if(!is_user_connected(id) || !g_corpse[id] || !g_canfreelook[id] || g_team[id] == CS_TEAM_SPECTATOR)
		return
	
	cs_set_user_team(id, CS_TEAM_SPECTATOR)
	message_begin(MSG_ALL, g_msgTeamInfo)
	write_byte(id)
	write_string(team_name[_:g_team[id]])
	message_end()
}

public stay_spec(id)
{
	g_team[id] = CS_TEAM_SPECTATOR
	message_begin(MSG_ALL, g_msgTeamInfo)
	write_byte(id)
	write_string("SPECTATOR")
	message_end()
}

public freelook_over()
{
	new players[32], num, id
	get_players(players, num, "bc")
	for(new i; i < num; i++)
	{
		id = players[i]
		if(!g_corpse[id] || g_team[id] == CS_TEAM_SPECTATOR) continue
		cs_set_user_team(id, g_team[id])
		g_corpse[id] = false
	}
}
